#include <stdio.h>
#include <stdlib.h>

// ??? ?? ?????????? (long long ???? ?????????? -10^9 ?? 10^9)
typedef long long coord_t;
typedef long long count_t;

// ????????? ?? ?????
typedef struct {
    coord_t x;
    coord_t y;
    // ???? ?? ??????? ?? ?????????
    coord_t key_plus; // x + y
    coord_t key_minus; // x - y
    coord_t key_y; // y
    int key_x_parity; // x % 2
    coord_t key_x; // x
    int key_y_parity; // y % 2
} Point;

// ???????? ???? ????? k * (k - 1) - ???? ???????? ??????
count_t getCount(count_t k) {
    if (k < 2) return 0;
    // ??? ?? 2 * (k choose 2), ??? ?????????? ?????? ???? ???????? 
    // ?? ????? ?? k ?????? ???? ?????????? ?????.
    return k * (k - 1);
}

// ----------------------------------------------------
// ????????? ?? qsort
// ----------------------------------------------------

// 1. ???????? ?? x + y (key_plus)
int compare_key_plus(const void *a, const void *b) {
    coord_t k1a = ((Point*)a)->key_plus;
    coord_t k1b = ((Point*)b)->key_plus;
    if (k1a < k1b) return -1;
    if (k1a > k1b) return 1;
    return 0;
}

// 2. ???????? ?? x - y (key_minus)
int compare_key_minus(const void *a, const void *b) {
    coord_t k2a = ((Point*)a)->key_minus;
    coord_t k2b = ((Point*)b)->key_minus;
    if (k2a < k2b) return -1;
    if (k2a > k2b) return 1;
    return 0;
}

// 3. ???????? ?? y, ?? ??????? x (?? ?????????? ???????)
int compare_vertical(const void *a, const void *b) {
    coord_t ya = ((Point*)a)->key_y;
    coord_t yb = ((Point*)b)->key_y;

    if (ya < yb) return -1;
    if (ya > yb) return 1;

    // ????????? ?? ???????? x
    int pxa = ((Point*)a)->key_x_parity;
    int pxb = ((Point*)b)->key_x_parity;
    return pxa - pxb;
}

// 4. ???????? ?? x, ?? ??????? y (?? ???????????? ???????)
int compare_horizontal(const void *a, const void *b) {
    coord_t xa = ((Point*)a)->key_x;
    coord_t xb = ((Point*)b)->key_x;

    if (xa < xb) return -1;
    if (xa > xb) return 1;

    // ????????? ?? ???????? y
    int pya = ((Point*)a)->key_y_parity;
    int pyb = ((Point*)b)->key_y_parity;
    return pya - pyb;
}

// ----------------------------------------------------
// ?????? ???????? ?? ??????
// ----------------------------------------------------

// ????? ???????? ?? ??????? ??????? ????? ?????????
void count_greetings(Point points[], int n, count_t *total_greetings, 
                     int (*comparator)(const void*, const void*)) 
{
    if (n <= 1) return;

    qsort(points, n, sizeof(Point), comparator);
    
    count_t current_count = 0;
    for (int i = 0; i < n; i++) {
        current_count++;
        
        // ??????? ?? ?? ?? ???? ????? ??? ?? ???? ????
        int is_last = (i == n - 1);
        int is_new_group;
        
        if (!is_last) {
            // ???? ??? ????????? ?? ?? ?? ????? points[i] ? points[i+1] ????????? 
            // ?? ????? ???? ?? ??????? ?? ?????????.
            // ????? qsort ???? ?? 'Point', ?????? ?? ????????? ???????? ?? ??????? ??????? ?????.
            is_new_group = (comparator(&points[i], &points[i+1]) != 0);
        } else {
            is_new_group = 1; // ????? ??????? ???? ???????? ?????
        }

        if (is_new_group) {
            // ???????? ?? k * (k-1) ?? ????? ???????? k
            *total_greetings += getCount(current_count);
            current_count = 0;
        }
    }
}

// ----------------------------------------------------
// main ????????
// ----------------------------------------------------

int main() {
    int N;
    // ????????? N
    if (scanf("%d", &N) != 1) {
        printf("0\n");
        return 0;
    }

    if (N <= 1) {
        printf("0\n");
        return 0;
    }

    Point *points = (Point*) malloc(N * sizeof(Point));
    if (points == NULL) return 1; 

    // ????????? ?????? ? ??????????????? ???????
    for (int i = 0; i < N; i++) {
        if (scanf("%lld %lld", &points[i].x, &points[i].y) != 2) {
            free(points);
            return 1;
        }
        
        points[i].key_plus = points[i].x + points[i].y;
        points[i].key_minus = points[i].x - points[i].y;
        
        // ?? ?????????? ???????
        points[i].key_y = points[i].y;
        points[i].key_x_parity = (points[i].x % 2 != 0); 
        
        // ?? ???????????? ???????
        points[i].key_x = points[i].x;
        points[i].key_y_parity = (points[i].y % 2 != 0);
    }
    
    count_t total_greetings = 0;

    // 1. ??????????? ??????? - ??? 1: x + y = ?????????
    count_greetings(points, N, &total_greetings, compare_key_plus);

    // 2. ??????????? ??????? - ??? 2: x - y = ?????????
    count_greetings(points, N, &total_greetings, compare_key_minus);

    // 3. ?????????? ???????: y = ????????? ? x ???? ????????
    count_greetings(points, N, &total_greetings, compare_vertical);

    // 4. ???????????? ???????: x = ????????? ? y ???? ????????
    count_greetings(points, N, &total_greetings, compare_horizontal);

    printf("%lld\n", total_greetings);

    free(points);
    
    return 0;
}